set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Figures 5 and 7

**1. Figure 5
use $path_out\Table9_predictions_within, clear	

*Calculate weighted means across industries
	foreach var of varlist DE* {
		bysort country year: egen mean`var'=sum(`var'*weight)
	}	
	foreach var of varlist DH* {
		bysort country year: egen mean`var'=sum(`var'*weight_h)
	}	
	foreach var of varlist DYn* DYr* DLS* {
		bysort country year: egen mean`var'=sum(`var'*weight_VA)
	}	
*Summing country weights across industries
	foreach var in weight_c weight_h_c weight_VA_c {
		bysort country year: egen tot`var'=sum(`var')
	}

	*Drop industry dimension	
	duplicates drop country year, force
	drop code
	keep country year mean* tot*
		renvars mean*, predrop(4)
		renvars tot*, predrop(3)

	
*Calculate weighted means across countries
	foreach var of varlist DE* {
		bysort year: egen mean`var'=sum(`var'*weight_c)
	}	
	foreach var of varlist DH* {
		bysort year: egen mean`var'=sum(`var'*weight_h_c)
	}	
	foreach var of varlist DYn* DYr* DLS* {
		bysort year: egen mean`var'=sum(`var'*weight_VA_c)
	}	
	*Drop country dimension	
	duplicates drop year, force
	replace country="all"
	drop weight*

*Calculate unweighted means across years
	collapse (mean) meanD*, by(country)
	renvars mean*, predrop(4)

	*Making graph with predictions averaged across years, weighted by country size
	reshape long DE_ DH_ DHW_ DYn_ DYr_ DLS_, i(country) j(type) string
	renvars D*, postdrop(1)
		
	replace type="a_own" if type=="own"
	replace type="b_sup" if type=="sup"
	replace type="c_cus" if type=="cus"
	replace type="d_agg" if type=="agg"
	replace type="e_net" if type=="net"
	sort  type
	gen 	modeltype=_n if type=="a_own"
	replace modeltype=_n+1 if type=="b_sup"
	replace modeltype=_n+2 if type=="c_cus"
	replace modeltype=_n+3 if type=="d_agg"
	replace modeltype=_n+4 if type=="e_net"
			
	gen sDE = string(DE, "%4.3f")
	gen sDH = string(DH, "%4.3f")			
	gen sDLS = string(DLS, "%4.3f")		
			
	*Employment
	twoway 	(bar DE modeltype, bcolor(navy) yline(0, lcolor(black)) ///
			bgcolor(white) plotregion(color(white)) graphregion(color(white)) ytitle("Predicted annual employment change" "(log points)") ///
			legend( order(1 "Prediction"))  ///
			legend(span) legend(rows(1)) xtitle(" ") ylabel(, val) ///
			xlabel( 1 `" "Direct" "effect" "' 3 `" "Supplier" "effect" "' 5 `"  "Customer" "effect" "'  7 `" "Final demand" "effect" "' 9 `" "Net" "effect" "', noticks) ///
			note("Predictions based on Table 9.") ) ///
			(scatter DE modeltype, msym(none) mlab(sDE) mlabpos(12) mlabsize(vsmall) mlabcolor(black) )				
		graph export "$path_out\Fig5A.eps", as(eps) replace		
		
	*Hours
	twoway 	(bar DH modeltype, bcolor(navy) yline(0, lcolor(black)) ///
			bgcolor(white) plotregion(color(white)) graphregion(color(white)) ytitle("Predicted annual hours worked change" "(log points)") ///
			legend( order(1 "Prediction"))  ///
			legend(span) legend(rows(1)) xtitle(" ") ylabel(, val) ///
			xlabel( 1 `" "Direct" "effect" "' 3 `" "Supplier" "effect" "' 5 `"  "Customer" "effect" "'  7 `" "Final demand" "effect" "' 9 `" "Net" "effect" "', noticks) ///
			note("Predictions based on Table 9.") ) ///
			(scatter DH modeltype, msym(none) mlab(sDH) mlabpos(12) mlabsize(vsmall) mlabcolor(black) )				
		graph export "$path_out\Fig5B.eps", as(eps) replace		
					
						
**2. Figure 7

	*Labor share change, adding between effect
	append using $path_out\Table9_predictions_betw_tot
	
	replace type = "f_net" if type=="e_net"
	sum DLS if type=="e_betw"
	local betw = r(mean)
	replace DLS=DLS + `betw' if type=="f_net"
	replace sDLS = string(DLS, "%4.3f")		

	sort type
	drop modeltype
	gen 	modeltype=_n if type=="a_own"
	replace modeltype=_n+1 if type=="b_sup"
	replace modeltype=_n+2 if type=="c_cus"
	replace modeltype=_n+3 if type=="d_agg"
	replace modeltype=_n+4 if type=="e_betw"
	replace modeltype=_n+5 if type=="f_net"
	
	*Labor share change			
	twoway 	(bar DLS modeltype, bcolor(navy) yline(0, lcolor(black)) ///
			bgcolor(white) plotregion(color(white)) graphregion(color(white)) ytitle("Predicted annual labor share change" "(log points)") ///
			legend( order(1 "Prediction"))  ///
			legend(span) legend(rows(1)) xtitle(" ") ylabel(, val) ///
			xlabel( 1 `" "Direct" "effect" "' 3 `" "Supplier" "effect" "' 5 `"  "Customer" "effect" "'  7 `" "Final demand" "effect" "' 9 `" "Composition" "effect" "' 11 `" "Net" "effect" "', noticks) ///
			note("Predictions based on Table 9.") ) ///
			(scatter DLS modeltype, msym(none) mlab(sDLS) mlabpos(6) mlabsize(vsmall) mlabcolor(black) )				
		graph export "$path_out\Fig7.eps", as(eps) replace		
									

